 IF EXISTS(    SELECT 1   FROM SYS.VIEWS WHERE NAME = 'V_TENTACLE_SYNC_MONITOR_CARGA')
    BEGIN
        DROP VIEW V_TENTACLE_SYNC_MONITOR_CARGA;
    END;
GO

--SELECT * FROM V_TENTACLE_SYNC_MONITOR_CARGA where STATUS= 'pendente'

CREATE VIEW V_TENTACLE_SYNC_MONITOR_CARGA AS
SELECT
	Agente,
	TABELA AS TabelaSqlServer,
	TABELA_DEST AS TabelaPostgres,
	SUM( [COUNT]) Qtd_Reg, 

	CASE WHEN STATUS=1 THEN 'APLICADA'
	ELSE
		CASE WHEN ISNULL(convert(varchar(1), [LAST_ERROR]),'') ='' THEN 'PENDENTE'
			 ELSE 'ERRO NA APLICACAO' 
		END
	END AS Status,
	
	
	 (CASE WHEN STATUS=1 THEN	0
	ELSE
		DATEDIFF(mi, min([DATE]),GETDATE())
	END) AS TempoEsperaMinutos,

	 (CASE WHEN STATUS=0 THEN 0
		ELSE DATEDIFF(mi, min([DATE_REG]),min([DATE_STATUS])) END 
		)AS TempoRespostaLojaMinutos
FROM
	TENTACLE_SYNC_MONITOR 
GROUP BY  
	AGENTE,
	TABELA,
	ISNULL(convert(varchar(1), [LAST_ERROR]),''),
	[STATUS],
	TABELA_DEST 
